<?php
require 'vendor/autoload.php';

use Google\Auth\OAuth2;
use GuzzleHttp\Client;

// Path to your Firebase service account key
$serviceAccountFile = __DIR__ . '/service-account.json';

// Load credentials
$credentials = json_decode(file_get_contents($serviceAccountFile), true);

// Project ID from Firebase Console
$projectId = $credentials['project_id'];

// Generate OAuth 2.0 access token using Google Auth
$oauth = new OAuth2([
    'audience' => 'https://oauth2.googleapis.com/token',
    'issuer' => $credentials['client_email'],
    'signingAlgorithm' => 'RS256',
    'signingKey' => $credentials['private_key'],
    'tokenCredentialUri' => 'https://oauth2.googleapis.com/token',
    'scope' => 'https://www.googleapis.com/auth/firebase.messaging'
]);

$authToken = $oauth->fetchAuthToken();
$accessToken = $authToken['access_token'];

// Target device token
$deviceToken = 'dkH9FKYqRFWKpEyI-0R0ci:APA91bFisS2vqh0-k7SMf2mmvKSUpH56-vZSKuZhHCw9GW4STBXWJQExDMK7BOmvYzdNuRX119SnDNrmfmxitxpoKtnn_rKqJgUHiwE5-cdu6du6wBbEPlc';

// FCM endpoint for HTTP v1 API
$fcmUrl = "https://fcm.googleapis.com/v1/projects/sixth-guru-93110/messages:send";

// Message payload
$message = [
    "message" => [
        "token" => $deviceToken,
        "notification" => [
            "title" => "Hello from HTTP v1 API",
            "body"  => "This push uses OAuth2 and a service account"
        ],
        "android" => [
            "priority" => "HIGH"
        ]
    ]
];

// Send request using Guzzle
$client = new Client();
$response = $client->post($fcmUrl, [
    'headers' => [
        'Authorization' => 'Bearer ' . $accessToken,
        'Content-Type'  => 'application/json'
    ],
    'json' => $message
]);

echo ":white_check_mark: Notification sent:\n";
echo $response->getBody();